<?php
/**
 *
 * The framework's functions and definitions
 */

define( 'WOODMART_THEME_DIR', get_template_directory_uri() );
define( 'WOODMART_THEMEROOT', get_template_directory() );
define( 'WOODMART_IMAGES', WOODMART_THEME_DIR . '/images' );
define( 'WOODMART_SCRIPTS', WOODMART_THEME_DIR . '/js' );
define( 'WOODMART_STYLES', WOODMART_THEME_DIR . '/css' );
define( 'WOODMART_FRAMEWORK', '/inc' );
define( 'WOODMART_DUMMY', WOODMART_THEME_DIR . '/inc/dummy-content' );
define( 'WOODMART_CLASSES', WOODMART_THEMEROOT . '/inc/classes' );
define( 'WOODMART_CONFIGS', WOODMART_THEMEROOT . '/inc/configs' );
define( 'WOODMART_HEADER_BUILDER', WOODMART_THEME_DIR . '/inc/modules/header-builder' );
define( 'WOODMART_ASSETS', WOODMART_THEME_DIR . '/inc/admin/assets' );
define( 'WOODMART_ASSETS_IMAGES', WOODMART_ASSETS . '/images' );
define( 'WOODMART_API_URL', 'https://xtemos.com/wp-json/xts/v1/' );
define( 'WOODMART_DEMO_URL', 'https://woodmart.xtemos.com/' );
define( 'WOODMART_PLUGINS_URL', WOODMART_DEMO_URL . 'plugins/' );
define( 'WOODMART_DUMMY_URL', WOODMART_DEMO_URL . 'dummy-content-new/' );
define( 'WOODMART_TOOLTIP_URL', WOODMART_DEMO_URL . 'theme-settings-tooltips/' );
define( 'WOODMART_SLUG', 'woodmart' );
define( 'WOODMART_CORE_VERSION', '1.1.5' );
define( 'WOODMART_WPB_CSS_VERSION', '1.0.2' );

if ( ! function_exists( 'woodmart_load_classes' ) ) {
	function woodmart_load_classes() {
		$classes = array(
			'class-singleton.php',
			'class-api.php',
			'class-config.php',
			'class-layout.php',
			'class-autoupdates.php',
			'class-activation.php',
			'class-notices.php',
			'class-theme.php',
			'class-registry.php',
		);

		foreach ( $classes as $class ) {
			require WOODMART_CLASSES . DIRECTORY_SEPARATOR . $class;
		}
	}
}

woodmart_load_classes();

new XTS\Theme();

define( 'WOODMART_VERSION', woodmart_get_theme_info( 'Version' ) );













// اضافه کردن فایل API ژاکت
require_once get_template_directory() . "/inc/zhaket-api.class.php";

/**
 * AJAX handler برای بررسی لایسنس
 */
add_action('wp_ajax_studiare_check_license', 'studiare_check_license_callback');
add_action('wp_ajax_nopriv_studiare_check_license', 'studiare_check_license_callback');

function studiare_check_license_callback() {

    // امنیت
    check_ajax_referer('studiare_license_nonce', 'security');

    $license_token = isset($_POST['license']) ? sanitize_text_field($_POST['license']) : "";

    if (!$license_token) {
        wp_send_json_error([
            'message' => '❌ لطفاً کد لایسنس را وارد کنید.'
        ]);
    }

    // محصول توکن
    $product_token = "3f467913-bcba-40c5-92bc-fb4904b4d561";

    // فراخوانی API ژاکت
    $result = Zhaket_License::install($license_token, $product_token);

    if ($result->status === "successful") {

        // ذخیره توکن در دیتابیس
        update_option('zhaket_license_token', $license_token);
        update_option('zhaket_license_installed', true);

        wp_send_json_success([
            'message' => '✅ لایسنس با موفقیت فعال شد.',
            'details' => $result->message
        ]);

    } else {

        update_option('zhaket_license_installed', false);

        wp_send_json_error([
            'message' => '❌ فعال‌سازی موفق نبود.',
            'details' => $result->message
        ]);
    }
}

/**
 * AJAX: حذف لایسنس
 */
add_action('wp_ajax_studiare_remove_license', 'studiare_remove_license_callback');
add_action('wp_ajax_nopriv_studiare_remove_license', 'studiare_remove_license_callback');

function studiare_remove_license_callback() {
    check_ajax_referer('studiare_license_nonce', 'security');

    // حذف اطلاعات
    delete_option('zhaket_license_token');
    delete_option('zhaket_license_installed');

    wp_send_json_success([
        'message' => '✅ لایسنس با موفقیت حذف شد.'
    ]);
}




function studiare_license_form_shortcode_ajax() {

    $nonce = wp_create_nonce('studiare_license_nonce');

    // وضعیت لایسنس نصب‌شده
    $saved_token  = get_option('zhaket_license_token', '');
    $is_installed = get_option('zhaket_license_installed', false);

    ob_start(); ?>

    <div id="zhaket-license-box" style="max-width:386px;padding:25px;background:#fff;border-radius:15px;margin:auto;">

        <h2 style="margin-bottom:20px;font-weight:700;font-size:20px;">فعال‌سازی لایسنس</h2>

        <!-- نمایش وضعیت لایسنس اگر قبلاً فعال شده -->
        <?php if ($is_installed && $saved_token): ?>
            <div id="zhaket-installed-info" style="padding:12px;background:#e6ffe6;border:1px solid #4caf50;border-radius:8px;margin-bottom:15px;font-size:14px;">
                ✅ لایسنس قبلاً با موفقیت فعال شده است.
            </div>

            <button id="zhaket-remove-license"
                    style="width:100%;padding:10px;background:#e53935;color:#fff;border:none;border-radius:8px;font-size:14px;cursor:pointer;margin-bottom:20px;">
                حذف لایسنس و فعال‌سازی مجدد
            </button>
        <?php endif; ?>

        <div id="zhaket-license-message" style="display:none;margin-bottom:15px;padding:12px;border-radius:8px;font-size:14px;"></div>

        <label style="font-weight:600;margin-bottom:6px;display:block;">کد لایسنس:</label>

        <input type="text"
               id="zhaket-license-input"
               value="<?php echo esc_attr($saved_token); ?>"
               placeholder="مانند: ZHKT-xxxx-xxxx"
               style="width:100%;padding:12px;border:1px solid #ddd;border-radius:8px;font-size:14px;margin-bottom:15px;">

        <button id="zhaket-license-btn"
                style="width:100%;padding:12px;background:#1eab9d;color:#fff;border:none;border-radius:8px;font-size:15px;cursor:pointer;font-weight:600;text-align: center;">
            بررسی و فعال‌سازی لایسنس
        </button>

        <div id="zhaket-spinner" style="display:none;text-align:center;margin-top:15px;">
            <div class="loader" style="border:4px solid #eee;border-top:4px solid #4a3aff;border-radius:50%;width:32px;height:32px;margin:auto;animation:spin 0.8s linear infinite;"></div>
        </div>

    </div>

    <style>
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>

    <script>
    (function($){

        // ✅ فعال‌سازی لایسنس
        $("#zhaket-license-btn").on("click", function(){

            var license = $("#zhaket-license-input").val().trim();
            var btn = $(this);
            var messageBox = $("#zhaket-license-message");
            var spinner = $("#zhaket-spinner");

            if(license === ""){
                messageBox
                    .css({"display":"block","background":"#ffe6e6","border":"1px solid #e53935"})
                    .html("❌ لطفاً کد لایسنس را وارد کنید.");
                return;
            }

            btn.prop("disabled", true).text("در حال بررسی...");
            spinner.show();
            messageBox.hide();

            $.ajax({
                url: "<?php echo admin_url('admin-ajax.php'); ?>",
                method: "POST",
                data: {
                    action: "studiare_check_license",
                    security: "<?php echo $nonce; ?>",
                    license: license
                },
                success: function(response){
                    spinner.hide();
                    btn.prop("disabled", false).text("بررسی و فعال‌سازی لایسنس");

                    if(response.success){
                        messageBox
                            .css({"display":"block","background":"#e6ffe6","border":"1px solid #4caf50"})
                            .html(response.data.message);

                        // ایجاد باکس سبز وقتی تازه فعال شد
                        $("#zhaket-installed-info").remove();
                        $("#zhaket-license-box").prepend(
                            '<div id="zhaket-installed-info" style="padding:12px;background:#e6ffe6;border:1px solid #4caf50;border-radius:8px;margin-bottom:15px;font-size:14px;">✅ لایسنس فعال شد.</div>'
                        );

                        // دکمه حذف را اضافه کن
                        $("#zhaket-remove-license").remove();
                        $("#zhaket-installed-info").after(
                            '<button id="zhaket-remove-license" style="width:100%;padding:10px;background:#e53935;color:#fff;border:none;border-radius:8px;font-size:14px;cursor:pointer;margin-bottom:20px;">حذف لایسنس و فعال‌سازی مجدد</button>'
                        );
                    } 
                    else {
                        messageBox
                            .css({"display":"block","background":"#ffe6e6","border":"1px solid #e53935"})
                            .html(response.data.message + "<br>" + (response.data.details || ""));
                    }
                },

                error: function(){
                    spinner.hide();
                    btn.prop("disabled", false).text("بررسی و فعال‌سازی لایسنس");

                    messageBox
                        .css({"display":"block","background":"#ffe6e6","border":"1px solid #e53935"})
                        .html("❌ خطا در ارتباط با سرور.");
                }
            });

        });


        // ✅ حذف لایسنس و فعال‌سازی مجدد
        $(document).on("click", "#zhaket-remove-license", function(){

            var btn = $(this);
            btn.text("در حال حذف...").prop("disabled", true);

            $.ajax({
                url: "<?php echo admin_url('admin-ajax.php'); ?>",
                method: "POST",
                data: {
                    action: "studiare_remove_license",
                    security: "<?php echo $nonce; ?>"
                },
                success: function(response){

                    $("#zhaket-installed-info").remove();
                    btn.remove();

                    $("#zhaket-license-message")
                        .css({"display":"block","background":"#e6ffe6","border":"1px solid #4caf50"})
                        .html("✅ لایسنس حذف شد. امکان فعال‌سازی مجدد وجود دارد.");

                    $("#zhaket-license-input").val("");
                }
            });

        });

    })(jQuery);
    </script>

    <?php
    return ob_get_clean();
}

add_shortcode("zhaket_license_form", "studiare_license_form_shortcode_ajax");
